<?php
if(isset($_POST['btn_chart']))
{
	$start_date	=	$this->input->post('start_date');
	$end_date	=	$this->input->post('end_date');
}
else
{
	$start_date	=	get_date(false);
	$end_date	=	get_date(false);
}
?>
<form name="form_chart_daily" id="form_chart_daily" action="" method="POST" class="custom">
	<div class="row">
    	<div class="two columns">
        	<input type="text" name="start_date" id="start_date"  value="<?php echo $start_date; ?>" class="required datepicker" readonly="readonly" />
        </div> <!-- /.two columns -->
        <div class="two columns">
        	<input type="text" name="end_date" id="end_date"  value="<?php echo $end_date; ?>" class="required datepicker" readonly="readonly" />
        </div> <!-- /.two columns -->
        <div class="two columns">
              <select style="display:none;" id="fiche_status" name="fiche_status" class="required">
                <option value="">HEPSI</option>
                <option value="approved">ONAYLANANLAR</option>
                <option value="ship">KARGOLANANLAR</option>
              </select>
              <div class="custom dropdown">
                <a href="#" class="current">
                  HEPSI
                </a>
                <a href="#" class="selector"></a>
                <ul>
                  <li>HEPSI</li>
                  <li>ONAYLANANLAR</li>
                  <li>KARGOLANANLAR</li>
                </ul>
              </div>
        </div> <!-- /.two columns -->
        <div class="two columns">
        	<input type="submit" name="btn_chart" class="button secondary" value="Rapor Hazırla" />
        </div> <!-- /.two columns -->
        <div class="one">
        </div>
    </div> <!-- /.row -->
</form>


<?php
if(isset($_POST['btn_chart']))
{
	$start_date	=	$this->input->post('start_date');
	$end_date	=	$this->input->post('end_date');
	
	$this->db->from('fiche_items');
	$this->db->where('status', '0');
	$this->db->where('type', '0');
	$this->db->where('cancel', '0');
	if($_POST['fiche_status'] == 'approved') 
	{ 
		$this->db->where('approved', '1');
		$this->db->where('date_approved >', $start_date.' 00:00:00');
	 	$this->db->where('date_approved <', $end_date.' 99:99:99'); 
	}
	elseif($_POST['fiche_status'] == 'ship') 
	{ 
		$this->db->where('approved', '1');
		$this->db->where('date_ship >', $start_date.' 00:00:00');
	 	$this->db->where('date_ship <', $end_date.' 99:99:99'); 
	}
	else
	{
	 	$this->db->where('date >', $start_date.' 00:00:00');
	 	$this->db->where('date <', $end_date.' 99:99:99');
	}
	$fiche_items	= $this->db->get()->result_array();
	
	$charts = array();
	foreach($fiche_items as $fiche_item)
	{
		if(!isset($charts[$fiche_item['product_id']])) 
		{
			$charts[$fiche_item['product_id']] 						= '';
			$charts[$fiche_item['product_id']]['amount'] 			= ''; 
			$charts[$fiche_item['product_id']]['purchase_price']	= '';  
			$charts[$fiche_item['product_id']]['grand_total']		= ''; 
			$charts[$fiche_item['product_id']]['ship_total']		= ''; 
			$charts[$fiche_item['product_id']]['tax']				= '';
		}
		
		$charts[$fiche_item['product_id']]['amount'] 			= $charts[$fiche_item['product_id']]['amount'] 			+ $fiche_item['amount']; 
		$charts[$fiche_item['product_id']]['purchase_price'] 	= $charts[$fiche_item['product_id']]['purchase_price'] 	+ ($fiche_item['purchase_price'] * $fiche_item['amount']);  
		$charts[$fiche_item['product_id']]['grand_total']		= $charts[$fiche_item['product_id']]['grand_total'] 		+ $fiche_item['grand_total'];
		$charts[$fiche_item['product_id']]['tax']				= $charts[$fiche_item['product_id']]['tax'] 		+ $fiche_item['tax'];
		
		if(!isset($charts[$fiche_item['fiche_id']]))
		{
			$charts[$fiche_item['product_id']]['ship_total']		= $charts[$fiche_item['product_id']]['ship_total'] 		+ $fiche_item['ship_total']; 
		}
	}
?>

<table width="100%" class="dataTable">
    <thead>
		<tr>
			<td colspan="2" style="font-size:20px; padding:15px;">STOK BİLGİLERİ</td>
			<td colspan="5" style="font-size:20px; padding:15px;">MALİYETLER</td>
			<td colspan="2" style="font-size:20px; padding:15px;">SONUÇ</td>
		</tr>
        <tr>
            <th style="cursor:pointer;">STOK KODU</th>
            <th style="cursor:pointer;">ADET</th>
            <th style="cursor:pointer;">SATIN ALMA</th>
            <th style="cursor:pointer;">KARGO</th>
            <th style="cursor:pointer;">REKLAM</th>
            <th style="cursor:pointer;">KDV</th>
			<th style="cursor:pointer;">NET MALIYET</th>
            <th style="cursor:pointer;">SATIŞ TUTARI</th>
            <th style="cursor:pointer;">KAR</th>
        </tr>
    </thead>
    <tbody>

    <?php
		$this->db->from('products');
		$products = $this->db->get()->result_array();
	?>
    	<?php foreach($products as $product) : ?>
			<?php if(isset($charts[$product['id']])) : ?>
			
				<?php
				
				
				
				// masraflar hesaplanıyor
				$this->db->from('expenses');
				$this->db->select_sum('total');
				$this->db->where('status', '1');
				$this->db->where('date >=', $start_date.'');
				$this->db->where('date <=', $end_date.'');
				$this->db->where('type', 'ADV');
				$this->db->where('product_id', $product['id']);
				$expenses = $this->db->get()->result_array();

				$adv_total = $expenses[0]['total'];
				
				
				$purchase_price	= $charts[$product['id']]['purchase_price'];
				$grand_total	= $charts[$product['id']]['grand_total'];
				$ship_total		= $charts[$product['id']]['ship_total'];
				$tax			= (($grand_total - $purchase_price) / 100) * $product['tax_rate'];
				$net_cost		= $purchase_price + $ship_total + $adv_total + $tax;
				
				
				
				
				$amount_of_profit = $charts[$product['id']]['grand_total'] - $net_cost;
				?>
				<tr>
					<td style="font-size:10px;"><?php echo $product['name']; ?></td>
					<td style="font-size:10px;"><?php echo $charts[$product['id']]['amount']; ?></td>
					<td class="text-right" style="font-size:10px;"><?php echo number_format($charts[$product['id']]['purchase_price'],2); ?> <span style="font-size:10px;">TL</span></td>
					<td class="text-right" style="font-size:10px;"><?php echo number_format($ship_total,2); ?> <span style="font-size:10px;">TL</span></td>
					<td class="text-right" style="font-size:10px;"><?php echo number_format($adv_total,2); ?> <span style="font-size:10px;">TL</span></td>
					<td class="text-right" style="font-size:10px;"><?php echo number_format($tax,2); ?> <span style="font-size:10px;">TL</span></td>
					<td class="text-right" style="font-size:10px;"><?php echo number_format($net_cost,2); ?> <span style="font-size:10px;">TL</span></td>
					<td class="text-right" style="font-size:10px;"><?php echo number_format($grand_total,2); ?> <span style="font-size:10px;">TL</span></td>
					<td class="text-right" style="font-size:10px;"><?php echo number_format($amount_of_profit,2); ?> <span style="font-size:10px;">TL</span></td>
				</tr>
			<?php endif; ?>
        <?php endforeach; ?>

    </tbody>
</table>

<?php } ?>