<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); ?>
<?php
// ALERT BOX
function alert_box($text, $style_type='', $title='')
{
	echo '
		<div class="alert-box '.$style_type.'">
			'.$text.'
			<a href="" class="close">&times;</a>
		</div>
	';
}


// ALERT BOXS
function check_alert_box($alert_box)
{
	if(!isset($alert_box['type'])){ $alert_box['type'] = ''; }
	if(!isset($alert_box['title'])){ $alert_box['title'] = ''; }
	
	alert_box($alert_box['text'], $alert_box['type'], $alert_box['title']);
}





/*
	KULLANICI YETKI KONTROLU
	@author: mustafa tanriverdi
	@description:
		* bu fonksiyon bir kullanıcnın yetkisini kontrol ederek, sayfaya erşip erişemiyeceğini kontrol eder.
		* öncelikle bu fonksiyon belirtilen sayfadaki kullanıcı yetkilendirmesine bakar.
		* eğer sayfa daha önce options tablosuna eklenmemiş ise tüm kullanıcıların erişebileceği yetki ile ekleme yapar.
*/
function check_user_role($f_name, $data='')
{
	$ci = & get_instance();
	
	// eğer süper admin güncelleme işlemini gerçekleştiriyorsanız
	if(isset($_POST['page_access']))
	{
		$page_access = $_POST['page_access'];
		
		$ci->db->where('option_key', 'page_access_'.$f_name);
		$ci->db->update('options', array('option_value'=>$page_access));
	}
	
	
	$ci->db->from('options');
	$ci->db->where('option_key', 'page_access_'.$f_name);
	$query = $ci->db->get()->result_array();
	
	if($query)
	{
		$user_access_role = $query[0]['option_value'];
		user_role($user_access_role);
		return $user_access_role;
	}
	else
	{
		$ci->db->insert('options', array('option_key'=>'page_access_'.$f_name, 'option_value'=>'5'));
		return 5;
	}
}



/*
	TARIH FONKSIYONLARI
	@description: 
		* burada tarih fonksiyonları yer almakta
*/

# DATA
function get_date($clock=true)
{
	if($clock == true) : return date('Y-m-d H:i:s');	else:	return date('Y-m-d');	endif;
}

function the_date($clock=false)
{
	echo get_date($clock=false);
}


# THE POST DATE
function the_post_date()
{
	echo date("YdmHis");
}




// SAYFA YENİLEME KONTROLÜ
function check_refresh()
{
	$ci = & get_instance();
	
	if($ci->session->userdata('datetime') == $_POST['datetime'])
	{
		return false;	
	}
	else
	{
		$ci->session->set_userdata('datetime', $_POST['datetime']);	
		return true;
	}
}



# MONEY FORMAT
function get_money($value)
{
	return number_format($value, 2);
}
function the_money($value)
{
	echo get_money($value);	
}


function karekterTemizle($tr1) 
{
	$turkce=array("ş","Ş","ı","ü","Ü","ö","Ö","ç","Ç","ş","Ş","ı","ğ","Ğ","İ","ö","Ö","Ç","ç","ü","Ü");
	$duzgun=array("s","S","i","u","U","o","O","c","C","s","S","i","g","G","I","o","O","C","c","u","U");
	$tr1=str_replace($turkce,$duzgun,$tr1);
	$tr1 = preg_replace("@[^a-z0-9\-_şıüğçİŞĞÜÇ]+@i","-",$tr1);
	return $tr1;
}



/*
	ADD LOG
*/
function add_log($data)
{
	$ci = & get_instance();
	
	$ci->global_model->add_log($data);	
}



/*
	FİŞ KONTROL
	@author: mustafa tanriverdi
	@description:
		* bu fonksiyon belirtilen fiş ID'deki tüm giriş ve çıkışları hesaplar
		* fişteki tüm hareketleri hesaplar ve fişin toplamına yansıtır
*/
function check_order($order_id)
{
	$ci = & get_instance();
	
	$ci->db->from('fiche_items');
	$ci->db->where('fiche_id', $order_id);
	$ci->db->where('status', '0');	
	$query = $ci->db->get()->result_array();
	
	$order_total = 0.00;
	$order_tax = 0.00;
	$order_grand_total = 0.00;
	foreach($query as $q)
	{
		$order_total		= $order_total + $q['total'];
		$order_tax			= $order_tax + $q['tax'];
		$order_grand_total 	= $order_grand_total + $q['grand_total'];
	}
	
	// fiş toplamlarını güncelle
	$values = array(
			'total'	=> $order_total,
			'tax'	=> $order_tax,
			'grand_total' => $order_grand_total
	);
	$ci->db->where('id', $order_id);
	$ci->db->update('fiches', $values);
}




/*
	CARİ KART BAKİYE HESAPLAMASI
	@author: mustafa tanriverdi
	@description
		* bu fonksiyon belirtilen cari karttaki giriş, çıkış ve ödemeleri hesaplar ve veritabanında günceller
		* tüm giriş fişlerini toplar
		* tüm çıkış fişlerini toplar
		* tüm ödemeleri hesaplar
		* çıkan sonucu carinin bakiyesine yansıtır
*/
function check_customer_card($customer_id)
{
	$ci = & get_instance();
	
	$ci->db->from('fiches');
	$ci->db->where('status', '0');
	$ci->db->where('customer_id', $customer_id);
	$orders = $ci->db->get()->result_array();
	
	$total = 0;
	foreach($orders as $order)
	{
		if($order['type'] == 0) // TYPE ÇIKIŞ İSE 
		{
			$total = $total + $order['grand_total'];	
		}
		else if($order['type'] == 1) // TYPE GİRİŞ İSE
		{
			$total = $total - $order['grand_total'];	
		}
	}
	
	
	// cari bakiyesini güncelle
	$values = array(
			'balance' => $total
	);
	$ci->db->where('id', $customer_id);
	$ci->db->update('customers', $values);
	
	
}



/*
	CHECK PRODUCT CARD
	@author: mustafa tanriverid
	@description:
		* bu fonksiyon belirtilen hareket ID'deki stok bilgilerini derler
*/
function check_product_card($product_id)
{
	$ci = & get_instance();
	
	$ci->db->from('fiche_items');
	$ci->db->where('status', '0');
	$ci->db->where('product_id', $product_id);
	$query = $ci->db->get()->result_array();
	
	$total_amount = 0;
	foreach($query as $q)
	{
		if($q['type'] == 0) // TYPE ÇIKIŞ İSE 
		{
			$total_amount = $total_amount - $q['amount'];	
		}
		else if($q['type'] == 1) // TYPE GİRİŞ İSE
		{
			$total_amount = $total_amount + $q['amount'];	
		}
	}
	
	
	// ürün kartını güncelle
	$ci->db->where('id', $product_id);
	$ci->db->update('products', array('amount'=>$total_amount));
}



/*
	STRING ISLEMLERI
*/
function get_text($value, $data='')
{
	$upper_lower = 'upper';
	
	if($upper_lower == 'upper')
	{
		return mb_strtoupper($value, 'UTF-8');
	}
}
function text($value, $data='')
{
	 echo get_text($value, $data);
}



/*
	image_url
*/
function image_url($value)
{
	return base_url('theme/images/'.$value);	
}


/*
	MESAJ SAYISI
	GELEN KUTUSUNDAKİ MESAJLARI SAYAR
*/
function calc_message_total($read_status, $data='')
{	
	$ci = & get_instance();
	
	$ci->db->from('user_msg');
	$ci->db->where('status', '0');
	$ci->db->where('read_status', $read_status);
	$ci->db->where('receiver_user_id', get_c_user('id'));
	$ci->db->where('archive', '0');
	return $ci->db->count_all_results();	
}



?>