<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Customer_Model extends CI_Model 
{
	/*
		CUSTOMER MODEL
		@author: mustafa tanriverdi, [array]
		@description:
			* Merhabalar, ben mustafa tanriverdi bu model dosyası aslında cari kart dosyasını temsil etmektedir. 
			* İngilizce "customer" kelimesinin karşılığı "müşteri" anlamına gelmektedir. 
				- Ama biz müşteriler ve tedarikçiler için customer modelini kullanıyoruz.
			* Burada temel fonksiyonlar kullanılmaktadır.
	*/
	
	public function index()
	{
		
	}
	
	
	
	/*
		ADD CUSTOMER
		@author: mustafa tanriverdi
		@description:
			* Bu fonksiyon yeni cari kart oluşturmaktadır.
	*/
	public function add_customer($data)
	{	
		$values = array(
					'code' 		=> $data['code'],
					'name'		=> $data['name'],
					'phone' 	=> $data['phone'],
					'gsm'		=> $data['gsm'],
					'email' 	=> $data['email'],
					'address'	=> $data['address'],
					'county'	=> $data['county'],
					'city'		=> $data['city'],
					'country'	=> $data['country'],
					'vd'	=> $data['vd'],
					'vno'	=> $data['vno']
					);
		
		$this->db->insert('customers', $values);
		return $this->db->insert_id();
	}
	
	
	
	/*
		GET CUSTOMER LIST
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon kayıtlı kullanıcıları döndürür
	*/
	function get_customer_list($data='')
	{
		$this->db->from('customers');
		$this->db->where('status', '0');
		$query = $this->db->get()->result_array();
		
		if($query)
		{
			return $query;
		}
		else
		{
			return false;
		}
	}
	
	
	
	/*
		CARİ KART
		@author: mustafa tanriverdi
		@description: 
			* bu fonksiyon kayıtlı cari kartı döndürür
	*/
	function get_customer($customer_id)
	{
		$this->db->from('customers');
		$this->db->where('id', $customer_id); 
		$query = $this->db->get()->result_array();
		
		if($query)
		{
			return $query[0];
		}
		else
		{
			return false;	
		}	
	}
	
	
	
	/*
		CARI KART GUNCELLEME
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon cari kart günceller
	*/
	function update_customer($data)
	{
		$values = array(
					'code' 		=> $data['code'],
					'name'		=> $data['name'],
					'phone' 	=> $data['phone'],
					'gsm'		=> $data['gsm'],
					'email' 	=> $data['email'],
					'address'	=> $data['address'],
					'county'	=> $data['county'],
					'city'		=> $data['city'],
					'country'	=> $data['country'],
					'vd'	=> $data['vd'],
					'vno'	=> $data['vno']
					);
		
		$this->db->where('id', $data['customer_id']);
		$this->db->update('customers', $values);
		return $this->db->affected_rows();
		
	}
	
	
	
}

